package gov.va.med.mhv.health.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
@Entity
@Table(name="PHR_CHEM_LAB")
public class ChemistryLab implements Serializable {
	
	private static final long serialVersionUID = 2216672629631998322L;
	
	@Id
	@Column(name="PHR_CHEM_LAB_ID")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Column(name="OPLOCK")
	private Integer oplock;
	
	/*
	@OneToMany(mappedBy="chemistryLab",fetch=FetchType.EAGER)
	private Set<ChemistryPanel> panels;  */
		
	
	@Column(name="COLLECTED_ON_DATE_PRECISE")
    @Temporal(TemporalType.TIMESTAMP)
	private Date collectedDatePrecise;
	
	@Column(name="COLLECTED_ON_DATE_IMPRECISE")
	private String collectedDateImprecise;
	
	@Column(name="RECORD_ID")
	private String recordId;
	
	@Column(name="SPECIMEN_SOURCE")
	private String specimenSource;
	
	@Column(name="PHR_FACILITY_CONTROL_ID")
	private Long facilityControlId;
	
	@Column(name="PATIENT_ID")
	private Long patientId;
	
	@Column(name="FACILITY_INFO_ID")
	private Long facilityInfoId;
	
	@Column(name="ORDERING_LOCATION")
	private String orderingLocation;
	
	@Column(name="ORDERING_PROVIDER")
	private String orderingProvider;
	
	@Column(name="STATION_NUMBER")
	private String stationNumber;
		
	@Lob
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="LID")
	private Integer lid;
	
	@Column(name="AMENDED_STATUS")
	private Integer amendedStatus;
	
	@Column(name="LAB_TYPE")
	private String labType;
	
	@Lob
	@Column(name="REPORT_TEXT")
	private String reportText;
	
	@Column(name="COMPLETED_ON_DATE_PRECISE")
    @Temporal(TemporalType.TIMESTAMP)
	private Date completedDatePrecise;
	
	@Column(name="COMPLETED_ON_DATE_IMPRECISE")
	private String completedDateImprecise;
		
	@Column(name="COLLECTION_SAMPLE")
	private String collectionSample;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getCollectedDatePrecise() {
		return collectedDatePrecise;
	}

	public void setCollectedDatePrecise(Date collectedDatePrecise) {
		this.collectedDatePrecise = collectedDatePrecise;
	}

	public String getCollectedDateImprecise() {
		return collectedDateImprecise;
	}

	public void setCollectedDateImprecise(String collectedDateImprecise) {
		this.collectedDateImprecise = collectedDateImprecise;
	}

	public String getRecordId() {
		return recordId;
	}

	public void setRecordId(String recordId) {
		this.recordId = recordId;
	}

	public String getSpecimenSource() {
		return specimenSource;
	}

	/*
	public Set<ChemistryPanel> getPanels() {
		return panels;
	}

	public void setPanels(Set<ChemistryPanel> panels) {
		this.panels = panels;
	}  */

	public void setSpecimenSource(String specimenSource) {
		this.specimenSource = specimenSource;
	}

	public Long getFacilityControlId() {
		return facilityControlId;
	}

	public void setFacilityControlId(Long facilityControlId) {
		this.facilityControlId = facilityControlId;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public Long getFacilityInfoId() {
		return facilityInfoId;
	}

	public void setFacilityInfoId(Long facilityInfoId) {
		this.facilityInfoId = facilityInfoId;
	}

	public String getOrderingLocation() {
		return orderingLocation;
	}

	public void setOrderingLocation(String orderingLocation) {
		this.orderingLocation = orderingLocation;
	}

	public String getOrderingProvider() {
		return orderingProvider;
	}

	public void setOrderingProvider(String orderingProvider) {
		this.orderingProvider = orderingProvider;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Integer getLid() {
		return lid;
	}

	public void setLid(Integer lid) {
		this.lid = lid;
	}

	public Integer getAmendedStatus() {
		return amendedStatus;
	}

	public void setAmendedStatus(Integer amendedStatus) {
		this.amendedStatus = amendedStatus;
	}

	public String getLabType() {
		return labType;
	}

	public void setLabType(String labType) {
		this.labType = labType;
	}

	public String getReportText() {
		return reportText;
	}

	public void setReportText(String reportText) {
		this.reportText = reportText;
	}

	public Date getCompletedDatePrecise() {
		return completedDatePrecise;
	}

	public void setCompletedDatePrecise(Date completedDatePrecise) {
		this.completedDatePrecise = completedDatePrecise;
	}

	public String getCompletedDateImprecise() {
		return completedDateImprecise;
	}

	public void setCompletedDateImprecise(String completedDateImprecise) {
		this.completedDateImprecise = completedDateImprecise;
	}

	public String getCollectionSample() {
		return collectionSample;
	}

	public void setCollectionSample(String collectionSample) {
		this.collectionSample = collectionSample;
	}

}
